function [A] = mhicia2a(A0,IS)
% -------------------------------------------------------------------------
% MHICIA2AI.M      MCMC Metropolis-Hastings independence chain (MHIC).
%                  Determine the target sample from a proposal sample and
%                  the selection indices.
% -------------------------------------------------------------------------
% A B Forbes, K Jagan, I M Smith, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Design documentation 
% [1] A B Forbes, An MCMC algorithm based on GUM Supplement 1 for 
% uncertainty evaluation, Measurement, 2012, 
% DOI:10.1016/j.measurement.2012.01.018
%
% [2] A B Forbes et al, User manual for MCM2MCMC: Software implementing a
% Markov chain Monte Carlo algorithm for uncertainty evaluation based on 
% Supplement 1 to the GUM, NPL Report MS/20, 2018
% -------------------------------------------------------------------------
% Input parameters
% A0(M,N)          Sample from the proposal distribution.
% IS(M,N)          Selection indices: A(i,j) = A0(IS(i,j),j).
%
% Output parameters
% A(M,N)           Markov chain consisting of draws from the proposal 
%                  distribution for which IS = 1. 
% -------------------------------------------------------------------------
% [A] = mhicia2a(A0,IS)
% -------------------------------------------------------------------------
  [M,N] = size(A0);
%  
% Initialisation. 
  A = zeros(M,N);
%
% Markov chains constructed from A0 and IS. 
  for r = 1:N
     A(:,r) = A0(IS(:,r),r);
  end % for r 
% -------------------------------------------------------------------------
% End of mhicia2a.m
% -------------------------------------------------------------------------