function [As,del] = jump_trw(A,R,nu)
% -------------------------------------------------------------------------
% jump_trw.m        Jumping distribution for the Metropolis Hastings
%                   random walk algorithm with a t jumping 
%                   distribution.
%                   To be used as function handle within mcmcmh.m. 
%                   @(A)jumprwt(A,R,nu). 
% -------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Inputs:
% A(p,N)            The current state of parameter array.
% R(p,p)            QR factorisation of J matrix.
% nu                Degrees of freedom of the t jumping distribution.
% Outputs:
% As(p,N)           Proposed parameter array which is randomly sampled from
%                   the jumping distribution.
% del               The difference between the logarithm of the
%                   jumping distribution associated with moving from A(:,j)
%                   to As(:,j) and that associated with moving from As(:,j)
%                   to A(:,j), up to an additive constant. 
%                   logJ(a|as) - logJ(as|a)
% -------------------------------------------------------------------------
% [As,del] = jump_trw(A,R,nu)
% -------------------------------------------------------------------------
% Number of parameters and parallel chains 
  [p,N] = size(A);

% Proposed draw from a t distribution with mean B, variance inv(R'R) and nu
% degrees of freedom 
  E = mvtrnd(eye(p),nu,N)';
  As = A + R\E; 

% For a random walk, since logJ(b|bs) = logJ(bs|b), del will always be
% zero
  del = 0;
% -------------------------------------------------------------------------
% End of jump_trw.m
% -------------------------------------------------------------------------
end 