function [As,del] = jump_grw(A,L)
% -------------------------------------------------------------------------
% JUMP_GRW          Jumping distribution for the Metropolis Hastings
%                   random walk algorithm with a Gaussian jumping 
%                   distribution.
%                   To be used as function handle within mcmcmh.m. 
%                   @(A)jump_grw(A,L). 
% -------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Inputs:
% A(p,N)            The current state of parameter array.
% L(p,p)            Cholesky factor of the variance of the parameter
%                   vector.
% Outputs:
% As(p,N)           Proposed parameter array which is randomly sampled from
%                   the jumping distribution.
% del               The difference between the logarithm of the
%                   jumping distribution associated with moving from A(:,j)
%                   to As(:,j) and that associated with moving from As(:,j)
%                   to A(:,j), up to an additive constant. 
%                   logJ(a|as) - logJ(as|a)
% -------------------------------------------------------------------------
% [As,del] = jump_grw(A,L)
% -------------------------------------------------------------------------
  [p,N] = size(A);

% Random draw from a Gaussian distribution 
  e = randn(p,N);

% Proposed draw from a Gaussian distribution with mean B and variance LL'
  As = A + L*e;

% For a random walk, since logJ(a|as) = logJ(as|a), del will always be
% zero
  del = 0;
% -------------------------------------------------------------------------
% End of jump_grw.m
% -------------------------------------------------------------------------
end 
