function [As, l0] = jumpicg(A0, L)
% -------------------------------------------------------------------------
% jumpicg.m         Jumping distribution for the Metropolis Hastings
%                   Gaussian independence chain algorithm.
%                   To be used as function handle within mcmcmhic.m.
% -------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Inputs:
% A0(n,N)           Mean of the Gaussian jumping distribution.
% L(n,n)            Cholesky factor of variance of parameter vector.
%
% Outputs:
% As(n,N)           Proposed parameter array which is randomly sampled
%                   from the jumping distribution.
% l0(1,N)           Log of the jumping distribution evaluated at As.
% -------------------------------------------------------------------------
% [As, l0] = jumpicg(A0, L)
% -------------------------------------------------------------------------

% number of parameters and parallel chains
  [n, N] = size(A0);

% random draw from a Gaussian distribution
  e = randn(n, N);

% proposed draw from a Gaussian distribution with mean A0 and variance LL'
  As = A0 + L*e;

% jumping density at As
  l0 = log(mvnpdf(As', A0', L*L'))';
% -------------------------------------------------------------------------
% End of jumpicg.m
% -------------------------------------------------------------------------
end