function T = tar_trw(a,fun,m0,s0)
%--------------------------------------------------------------------------
% tar_trw.m         Log of the marginal posterior distribution of alpha. 
%                   Data subject to Gaussian noise.
%                   Alpha has non-informative prior and Phi has gamma prior
%                   characterised by a degree of belief term, m0 and
%                   standard deviation term s0.
%                   $\phi \sim \rm{G}(m_0/2,m_0 s_0^2/2)$. 
%                   Phi analytically marginalised.
%--------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
%--------------------------------------------------------------------------
% Inputs:
% a(n,N)            Matrix of alphas for N parallel chains.  
% fun               Function handle that takes as input alpha values 
%                   and returns the non linear least squares function, f,
%                   and the matrix of derivatives of f with respect to each
%                   input, J. 
% m0                Prior degrees of freedom.
% s0                Prior estimate of standard deviation. 
% Output:
% T(1,N)            Log of marginal posterior of alpha. 
%--------------------------------------------------------------------------
% T = tar_trw(a,fun,m0,s0)
%--------------------------------------------------------------------------
% Function values evaluated at a
  f = fun(a);

% Length of data vector and number of parameters
  m = size(f,1);
  n = size(a,1);
  
% Log of the posterior distribution for alpha 
  T = -((m+m0)/2)*log((m0*s0^2 + sum(f.^2))/(m+m0-n)*s0^2); 
%--------------------------------------------------------------------------
% End of tar_trw.m
%--------------------------------------------------------------------------
end 
